import { ExpView, isExist } from '@core';
import { deepCopy, hasFunction } from '@core/utils';
import { TabExpViewProps } from './tab-exp-view-prop';
import { TabExpViewState } from './tab-exp-view-state';

/**
 * @description 分页导航视图
 * @export
 * @class TabExpView
 * @extends {ExpView}
 */
export class TabExpView extends ExpView {
  /**
   * @description 视图状态
   * @type {TabExpViewState}
   * @memberof TabExpView
   */
  public declare state: TabExpViewState;

  /**
   * 视图输入参数
   *
   * @type {TabExpViewProps}
   * @memberof TabExpView
   */
  public declare props: TabExpViewProps;

  /**
   *【内置功能】提供通过viewparams里的srfdefaultpanel指定默认打开的分页的功能
   */
  public useDefaultPanel() {
    const { srfdefaultpanel } = this.state.viewParams;
    if (isExist(srfdefaultpanel)) {
      this.state.defaultActivePanel = srfdefaultpanel;
    }
  }

  /**
   * 使用加载模型模块
   *
   * @private
   * @memberof TabExpView
   */
  private useLoadModel() {
    const { context, appEntityCodeName, appDeMajorFieldName } = this.state;
    if (context && context[appEntityCodeName.toLowerCase()]) {
      const tempContext = deepCopy(context);
      //  从数据模式标识
      if (tempContext.srfsessionid) {
        tempContext.srfsessionkey = tempContext.srfsessionid;
        delete tempContext.srfsessionid;
      }
      App.getDataService(appEntityCodeName.toLowerCase(), tempContext).then((service: any) => {
        if (service && hasFunction(service, 'getDataInfo')) {
          service.getDataInfo(tempContext, {}, false).then((response: any) => {
            if (response && response.status === 200) {
              this.state.viewCtx['viewGlobal'] = response.data;
              //  TODO 计算工具栏权限
              if (appDeMajorFieldName && response.data[appDeMajorFieldName]) {
                this.state.viewCaption += ` - ${response.data[appDeMajorFieldName]}`;
              }
            }
          });
        }
      }).catch((error: any) => {
        console.warn('获取实体服务异常');
      });
    }
  }

  /**
   * @description 安装视图所有功能模块的方法
   * @return {*}
   * @memberof TabExpView
   */
  public moduleInstall() {
    const superParams = super.moduleInstall();
    this.useDefaultPanel();
    this.useLoadModel();
    return {
      ...superParams,
    };
  }
}
